<?php
/* --------------------------------------------------------------
   FetchSpecificTrackingCodeAction.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\TrackingCode\Actions;

use Gambio\Admin\TrackingCode\Exceptions\TrackingCodeNotFoundException;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeService;
use Gambio\Admin\TrackingCode\Model\TrackingCodeId;
use Gambio\Api\Application\Responses\CreateApiMetaDataTrait;
use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class FetchSpecificTrackingCodeAction
 *
 * @package Gambio\Api\TrackingCode\Actions
 */
class FetchSpecificTrackingCodeAction
{
    use CreateApiMetaDataTrait;
    
    /**
     * @var TrackingCodeService
     */
    private $service;
    
    
    /**
     * FetchSpecificTrackingCodeAction constructor.
     *
     * @param TrackingCodeService $service
     */
    public function __construct(TrackingCodeService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        try {
            $trackingCodeId = TrackingCodeId::create((int)$request->getAttribute('id'));
            $trackingCode   = $this->service->getTrackingCodeById($trackingCodeId);
            $metaData       = $this->createApiMetaData();
            
            return $response->withJson([
                                           'data'  => $trackingCode,
                                           '_meta' => $metaData,
                                       ]);
        } catch (TrackingCodeNotFoundException $e) {
            return $response->withStatus(404);
        }
    }
}